% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seromodel.R
\name{plot_seroprev_estimates}
\alias{plot_seroprev_estimates}
\title{Plot seroprevalence estimates on top of the serosurvey}
\usage{
plot_seroprev_estimates(
  seromodel,
  serosurvey,
  alpha = 0.05,
  size_text = 11,
  bin_serosurvey = FALSE,
  bin_step = 5
)
}
\arguments{
\item{seromodel}{stan_fit object obtained from sampling a model
with \link{fit_seromodel}}

\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{alpha}{1 - alpha indicates the credibility level to be used}

\item{size_text}{Size of text for plotting (\code{base_size} in
\link[ggplot2:ggtheme]{ggplot2})}

\item{bin_serosurvey}{If \code{TRUE}, \code{serodata} is binned by means of
\code{prepare_bin_serosurvey}.
Otherwise, age groups are kept as originally input.}

\item{bin_step}{Integer specifying the age groups bin size to be used when
\code{bin_serosurvey} is set to \code{TRUE}.}
}
\value{
ggplot object with seroprevalence estimates and serosurveys plots
}
\description{
Plot seroprevalence estimates on top of the serosurvey
}
\examples{
data(veev2012)
seromodel <- fit_seromodel(veev2012, iter = 100)
plot_seroprev_estimates(seromodel, veev2012)
}
