% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sg.R
\name{sg_mime}
\alias{sg_mime}
\alias{sg_from}
\alias{sg_to}
\alias{sg_cc}
\alias{sg_bcc}
\alias{sg_subject}
\alias{sg_body}
\alias{sg_attachments}
\alias{sg_send}
\title{Create and send MIME formatted message objects}
\usage{
sg_mime()

sg_from(x, email)

sg_to(x, ...)

sg_cc(x, ...)

sg_bcc(x, ...)

sg_subject(x, subject)

sg_body(x, body, type = "text/html")

sg_attachments(x, ...)

sg_send(x, api_key = Sys.getenv("SENDGRID_API_KEY"))
}
\arguments{
\item{x}{A MIME object.}

\item{email}{The sender's email address.}

\item{...}{One or more email addresses.}

\item{subject}{The email subject.}

\item{body}{The body content of the email.}

\item{type}{The content type (e.g., "text/plain")}

\item{api_key}{SendGrid API key. Defaults to the environment variable \code{SENDGRID_API_KEY} if not provided.}
}
\value{
A MIME object.
}
\description{
Methods for creating and sending MIME messages.
}
\examples{
\dontrun{
  sg_mime() |>
    sg_from("sender@example.com") |>
    sg_to("recipient1@example.com", "recipient2@example.com") |>
    sg_cc("cc1@example.com", "cc2@example.com") |>
    sg_bcc("bcc1@example.com", "bcc2@example.com") |>
    sg_subject("This is the subject") |>
    sg_body("Hello from sg!") |>
    sg_attachments("path/to/file1.csv", "path/to/file2.pdf") |>
    sg_send()
}
}
