% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peaks_resample_95_CI.R
\name{PeaksInKsDistributionValues}
\alias{PeaksInKsDistributionValues}
\title{Find Peaks in the Ks Distribution}
\usage{
PeaksInKsDistributionValues(
  ks,
  binWidth = 0.1,
  maxK = 5,
  m = 3,
  peak.maxK = 2,
  spar = 0.25
)
}
\arguments{
\item{ks}{A numeric vector containing Ks values for which peaks will be identified.}

\item{binWidth}{A numeric value specifying the bin width for creating the histogram.}

\item{maxK}{A numeric value indicating the maximum Ks value to consider.}

\item{m}{An integer indicating the half-width of the neighborhood to consider when identifying peaks. A larger value of \code{m} makes peak detection less sensitive.}

\item{peak.maxK}{A numeric value specifying the maximum Ks value to consider when identifying peaks.}

\item{spar}{A numeric value controlling the smoothness of the spline fit. Higher values make the fit smoother.}
}
\value{
A numeric vector containing the identified peaks in the Ks distribution.
}
\description{
This function identifies peaks in a distribution of Ks (synonymous substitution rates) values.
}
