% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PATH-model.R
\name{PATH}
\alias{PATH}
\alias{PATH.SC}
\alias{PATH.TRI}
\alias{PATH.default}
\title{PATH model.}
\usage{
PATH(x, ...)

\method{PATH}{SC}(x, ...)

\method{PATH}{TRI}(x, ...)

\method{PATH}{default}(x, ...)
}
\arguments{
\item{x}{input model}

\item{...}{arguments passed to methods}
}
\value{
a PATH model, with tables 'object', 'path', 'path_link_vertex' and 'vertex'
}
\description{
A PATH model is a direct translation of a simple features-alike
object to normal form. This is four tables with the three kinds of entities,
"objects" (or "features"), "paths" (or "parts") and "vertices", and a table
to link the one-to-many relation between paths and vertices.
}
\details{
In a data set with no parts touching their  neighbours, the only normalization of the vertices
will be the removal of the duplicated closing coordinate on any polygon ring, and on
any self-intersecting case within a single path.

\code{PATH()$path} should always have columns \verb{object_ path_ subobject ncoords_}
}
\seealso{
\code{sc_path}, \code{sc_coord}
}
