% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{dplyr-methods}
\alias{dplyr-methods}
\alias{filter.SC}
\alias{filter}
\title{Dplyr methods for silicate objects}
\usage{
\method{filter}{SC}(.data, ...)
}
\arguments{
\item{.data}{data object of class SC}

\item{...}{passed to \code{dplyr::filter}}
}
\value{
an \code{\link[=SC]{SC()}} model, with some parts filtered out
}
\description{
Filter an SC model, currently only \code{dplyr::filter} for \code{SC} is available.
}
\details{
Apply expressions as if used on the \code{object} table. See \code{sc_object(x)} for that form.

Currently all the vertices are still kept, so the model (and any plots) include the filtered edges as well
as undifferentiated points. This is likely to change ...
}
\examples{
library(dplyr)
sc <- SC(inlandwaters)
plot(filter(sc, Province == "Tasmania"))
plot(filter(sc, Province \%in\% c("Victoria", "South Australia", "New South Wales")))

plot(filter(SC(minimal_mesh), a == 1))
}
