% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangles.R
\name{tri_area}
\alias{tri_area}
\title{Area of triangles}
\usage{
tri_area(x)
}
\arguments{
\item{x}{matrix of triangle coordinates}
}
\value{
numeric, area of triangles
}
\description{
Input is x,y matrix in triplets, with 3 rows per triangle vertex.
}
\examples{
pts <- structure(c(5L, 3L, 1L, 4L, 4L, 8L, 6L, 9L), .Dim = c(4L, 2L))
tri <- c(2, 1, 3, 2, 4, 1)
(a <- tri_area(pts[tri, ]))
plot(pts)
polygon(pts[head(as.vector(rbind(matrix(tri, nrow = 3), NA)), -1), ])
text(tapply(pts[tri,1], rep(1:2, each = 3), mean),
     tapply(pts[tri,2], rep(1:2, each = 3), mean), labels = sprintf("area: \%0.1f", a))
}
