% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simtimer.R
\name{as.datetime}
\alias{as.datetime}
\title{Back-transformation from a sim_datetime to a datetime}
\usage{
as.datetime(sim_datetime, origin_date)
}
\arguments{
\item{sim_datetime}{A sim_datetime (integer representing the passed seconds since origin_date)}

\item{origin_date}{A datetime (POSIXt)}
}
\value{
datetime A POSIXt
}
\description{
as.datetime() transforms a sim_datetime element (integer) to a regular datetime
element (POSIXt)
}
\examples{
origin_date <- as.POSIXct("2016-01-01 00:00:00", tz = "UTC")
as.datetime(60, origin_date)
# [1] "2016-01-01 00:01:00 UTC"
as.datetime(600, origin_date)
# [1] "2016-01-01 00:10:00 UTC"
as.datetime(as.sim_datetime(as.POSIXct("2016-01-02 00:00:00", tz = "UTC"), origin_date),
origin_date)
# [1] "2016-01-02 UTC"
}
