% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simtimer.R
\name{sim_time}
\alias{sim_time}
\title{Time part of a sim_datetime}
\usage{
sim_time(sim_datetime)
}
\arguments{
\item{sim_datetime}{A sim_datetime (integer representing the passed seconds since origin_date)}
}
\value{
time in seconds (Range: 0-(24*60*60-1))
}
\description{
sim_time() returns the time of a sim_datetime in seconds.
The beginning of a day is defined by the time component of origin_date which defines the
parameter sim_datetime.
}
\examples{
sim_time(200)
# [1] 200
sim_time(24*60*60-1)
# [1] 86399
sim_time(24*60*60)
# [1] 0
origin_date <- as.POSIXct("2016-01-01 00:00:00", tz = "UTC")
sim_time(as.sim_datetime(as.POSIXct("2016-01-01 00:01:00", tz = "UTC"), origin_date))
# [1] 60
sim_time(as.sim_datetime(as.POSIXct("2016-01-02 00:01:00", tz = "UTC"), origin_date))
# [1] 60
}
