% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{haystack}
\alias{haystack}
\alias{haystack.matrix}
\alias{haystack.data.frame}
\alias{haystack.Seurat}
\alias{haystack.SingleCellExperiment}
\title{The main Haystack function}
\usage{
haystack(x, ...)

\method{haystack}{matrix}(
  x,
  expression,
  weights.advanced.Q = NULL,
  dir.randomization = NULL,
  scale = TRUE,
  grid.points = 100,
  grid.method = "centroid",
  ...
)

\method{haystack}{data.frame}(
  x,
  expression,
  weights.advanced.Q = NULL,
  dir.randomization = NULL,
  scale = TRUE,
  grid.points = 100,
  grid.method = "centroid",
  ...
)

\method{haystack}{Seurat}(
  x,
  coord,
  assay = "RNA",
  slot = "data",
  dims = NULL,
  cutoff = 1,
  method = NULL,
  weights.advanced.Q = NULL,
  ...
)

\method{haystack}{SingleCellExperiment}(
  x,
  assay = "counts",
  coord = "TSNE",
  dims = NULL,
  cutoff = 1,
  method = NULL,
  weights.advanced.Q = NULL,
  ...
)
}
\arguments{
\item{x}{a matrix or other object from which coordinates of cells can be extracted.}

\item{...}{further parameters passed down to methods.}

\item{expression}{a matrix with expression data of genes (rows) in cells (columns)}

\item{weights.advanced.Q}{If NULL naive sampling is used. If a vector is given (of length = no. of cells) sampling is done according to the values in the vector.}

\item{dir.randomization}{If NULL, no output is made about the random sampling step. If not NULL, files related to the randomizations are printed to this directory.}

\item{scale}{Logical (default=TRUE) indicating whether input coordinates in x should be scaled to mean 0 and standard deviation 1.}

\item{grid.points}{An integer specifying the number of centers (gridpoints) to be used for estimating the density distributions of cells. Default is set to 100.}

\item{grid.method}{The method to decide grid points for estimating the density in the high-dimensional space. Should be "centroid" (default) or "seeding".}

\item{coord}{name of coordinates slot for specific methods.}

\item{assay}{name of assay data for Seurat method.}

\item{slot}{name of slot for assay data for Seurat method.}

\item{dims}{dimensions from coord to use. By default, all.}

\item{cutoff}{cutoff for detection.}

\item{method}{choose between highD (default) and 2D haystack.}
}
\value{
An object of class "haystack"
}
\description{
The main Haystack function
}
