% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_hypotheses.R
\name{shypo}
\alias{shypo}
\title{Testing simple hypotheses}
\usage{
shypo(
  mu0 = 0,
  sd = 6,
  eff = sd,
  n = 10,
  a = mu0 + eff/2,
  target_alpha = 0.05,
  target_beta = 0.1,
  panel_plot = TRUE,
  hscale = NA,
  vscale = hscale,
  delta_n = 1,
  delta_a = sd/(10 * sqrt(n)),
  delta_eff = sd,
  delta_mu0 = 1,
  delta_sd = 1
)
}
\arguments{
\item{mu0}{A numeric scalar.  The value of \eqn{\mu} under the null
hypothesis H0 with which to start the movie.}

\item{sd}{A positive numeric scalar.  The (common) standard deviation
\eqn{\sigma} of the normal distributions of the data under the two
hypotheses.}

\item{eff}{A numeric scalar.  The \emph{effect size}. The amount by which
the value of \eqn{\mu} under the alternative hypothesis is greater than
the value \code{mu0} under the null hypothesis.
That is, \code{mu1} = \code{eff} + \code{mu0}.
\code{eff} must be non-negative.}

\item{n}{A positive integer scalar.  The sample size with which to start
the movie.}

\item{a}{A numeric scalar.  The critical value of the test with which to
start the movie. H0 is rejected if the sample mean is greater than
\code{a}.}

\item{target_alpha}{A numeric scalar in (0,1).  The target value of the
type I error to be achieved by setting \code{a} and/or \code{n}
if the user asks for this using a radio button.}

\item{target_beta}{A numeric scalar in (0,1).  The target value of the
type II error to be achieved by setting \code{a} and/or \code{n}
if the user asks for this using a radio button.}

\item{panel_plot}{A logical parameter that determines whether the plot
is placed inside the panel (\code{TRUE}) or in the standard graphics
window (\code{FALSE}).  If the plot is to be placed inside the panel
then the tkrplot library is required.}

\item{hscale, vscale}{Numeric scalars.  Scaling parameters for the size
of the plot when \code{panel_plot = TRUE}. The default values are 1.4 on
Unix platforms and 2 on Windows platforms.}

\item{delta_mu0, delta_eff, delta_a, delta_n, delta_sd}{Numeric scalars.  The
respective amounts by which the values of \code{mu0, eff, a, n} and
\code{sd} are increased (or decreased) after one click of the + (or -)
button in the parameter window.}
}
\value{
Nothing is returned, only the animation is produced.
}
\description{
A movie to illustrate statistical concepts involved in the testing
of one simple hypothesis against another.  The example used is a
random sample from a normal distribution whose variance is assumed
to be known.  The simple hypotheses relate to the value of the mean
\eqn{\mu}.
}
\details{
The movie is based on two plots.

  The top plot shows the (normal)
  probability density functions of the sample mean under the null
  hypothesis H0 (mean \code{mu0}) and the alternative hypothesis H1
  (mean \code{mu1}, where \code{mu1} > \code{mu0}), with the values
  of \code{mu0} and \code{mu1} indicated by vertical dashed lines.
  H0 is rejected if the sample mean exceeds the critical value \code{a},
  which is indicated by a vertical black line.

  The bottom plot shows how the probabilities of making a type I or type II
  error (alpha and beta respectively) depend on the value of \code{a},
  by plotting these probabilities against \code{a}.

  A parameter window enables the user to change the values of \code{n},
  \code{a}, \code{mu0}, \code{eff} = \code{mu1} - \code{mu0} or \code{sd}
  by clicking the +/- buttons.

  Radio buttons can be used either to:
  \itemize{
    \item set \code{a} to achieve the target type I error probability
      \code{target_alpha}, based on the current value of \code{n};
    \item set \code{a} and (integer) \code{n} to achieve (or better) the
      respective target type I and type II error probabilities of
      \code{target_alpha} and \code{target_beta}.
  }
  If \code{eff = 0} then a plot will be produced even though this case is
  not practically meaningful.  In the "set a and n to achieve target alpha
  and beta" case, the plot will be the same as the case "set a and n by
  hand" case.
}
\examples{
# 1. Change a (for fixed n) to achieve alpha = 0.05
# 2. Change a and n to achieve alpha <= 0.05 and beta <= 0.1
shypo(mu0 = 0, eff = 5, n = 16, a = 2.3, delta_a = 0.01)
}
\seealso{
\code{\link{movies}}: a user-friendly menu panel.

\code{\link{smovie}}: general information about smovie.
}
