% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socialrisk.R
\name{socialrisk}
\alias{socialrisk}
\title{Social Risk}
\usage{
socialrisk(dat = NULL, id = NULL, dx = "dx", taxonomy = "cms")
}
\arguments{
\item{dat}{dataset which has been properly prepared in long format}

\item{id}{variable of the unique patient identifier}

\item{dx}{the column with the diagnoses (defaults to 'dx')}

\item{taxonomy}{the taxonomy one wishes to use for social risk, with options of
"cms" (default), "mha", and "siren"}
}
\value{
dataframe with one row per patient, a column for their patient id,
a column with whether they have any social risk, a column with the number
of social risk domains, and columns with indicator variables for each social risk
}
\description{
\code{socialrisk} returns a summary dataset containing indicators of social risk,
which vary based on the taxonomy command, for each patient.
}
\details{
This function uses data which has been properly prepared to identify and flag
social risks.
}
\examples{
data <- clean_data(dat = i10_wide, id = patient_id, style = "wide", prefix_dx = "dx")
socialrisk(dat = data, id = patient_id, dx = dx, taxonomy = "cms")

}
