% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbouring_sf.R
\name{network_listw}
\alias{network_listw}
\title{Network distance listw}
\usage{
network_listw(
  origins,
  lines,
  maxdistance,
  method = "centroid",
  point_dist = NULL,
  snap_dist = Inf,
  line_weight = "length",
  mindist = 10,
  direction = NULL,
  dist_func = "inverse",
  matrice_type = "B",
  grid_shape = c(1, 1),
  verbose = FALSE,
  digits = 3,
  tol = 0.1
)
}
\arguments{
\item{origins}{A feature collection of lines, points, or polygons
for which the spatial neighbouring list will be built}

\item{lines}{A feature collection of lines representing the network}

\item{maxdistance}{The maximum distance between two observations to
consider them as neighbours.}

\item{method}{A string indicating how the starting points will be built.
If 'centroid' is used, then the centre of lines or polygons is used. If
'pointsalong' is used, then points will be placed along polygons' borders or
along lines as starting and end points. If 'ends' is used (only for lines)
the first and last vertices of lines are used as starting and ending points.}

\item{point_dist}{A float, defining the distance between points when the
method 'pointsalong' is selected.}

\item{snap_dist}{The maximum distance to snap the start and end points on
the network.}

\item{line_weight}{The weighting to use for lines. Default is "length"
(the geographical length), but can be the name of a column. The value is
considered proportional to the geographical length of the lines.}

\item{mindist}{The minimum distance between two different observations.
It is important for it to be different from 0 when a W style is used.}

\item{direction}{Indicates a field providing information about authorized
travelling direction on lines. if NULL, then all lines can be used in both
directions. Must be the name of a column otherwise. The values of the
column must be "FT" (From - To), "TF" (To - From) or "Both".}

\item{dist_func}{Indicates the function to use to convert the distance
between observation in spatial weights. Can be 'identity', 'inverse',
'squared inverse' or a function with one parameter x that will be
vectorized internally}

\item{matrice_type}{The type of the weighting scheme. Can be 'B' for Binary,
'W' for row weighted, or 'I' (identity), see the documentation of spdep::nb2listw for details}

\item{grid_shape}{A vector of length 2 indicating the shape of the grid to
use for splitting the dataset. Default is c(1,1), so all the calculation is
done in one go. It might be necessary to split it if the dataset is large.}

\item{verbose}{A Boolean indicating if the function should print its
progress}

\item{digits}{The number of digits to retain in the spatial coordinates (
simplification used to reduce risk of topological error)}

\item{tol}{A float indicating the spatial tolerance when points are
added as vertices to lines.}
}
\value{
A listw object (spdep like) if matrice_type is "B" or "W". If
matrice_type is I, then a list with a nblist object and a list of weights
is returned.
}
\description{
Generate listw object (spdep like) based on network distances.
}
\examples{
\donttest{
data(mtl_network)
listw <- network_listw(mtl_network,
    mtl_network,
    maxdistance = 500,
    method = "centroid",
    line_weight = "length",
    dist_func = 'squared inverse',
    matrice_type='B',
    grid_shape = c(2,2))
}
}
