% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points_in_circle.R
\name{points_in_circle_vec}
\alias{points_in_circle_vec}
\title{Filter observations within circle (vectorized)}
\usage{
points_in_circle_vec(
  data,
  lon_center,
  lat_center,
  lon = lon,
  lat = lat,
  radius = 200
)
}
\arguments{
\item{data}{data.frame with at least columns for longitude and latitude.}

\item{lon_center}{numeric. Representing the longitude of the circle's center.}

\item{lat_center}{numeric. Representing the latitude of the circle's center.}

\item{lon}{column name in \code{data} containing longitudes
(default is \code{lon}).}

\item{lat}{column name in \code{data} containing latitudes
(default is \code{lat}).}

\item{radius}{radius of the circle in meters (default is 200m).}
}
\value{
A subset of the input data.frame containing only the observations
that fall within the specified circle.
}
\description{
Filter all observations in a data.frame that fall within a
circle of a specified radius drawn around a given latitude and longitude
point.
}
\examples{
points_in_circle_vec(Groningen, lon_center = c(6.571561, 6.56561),
lat_center = c(53.21326, 53.20326), radius = 60)

}
\author{
Martin Haringa
}
