% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spef_data.R
\docType{data}
\name{skinTumor}
\alias{skinTumor}
\title{Skin cancer chemoprevention trial}
\format{This data frame contains the following columns:
\describe{
  \item{\code{id}}{: patient id (repeated for each recurrence).}
  \item{\code{time}}{: observation time.}
  \item{\code{age}}{: patient's age at enrollment.}
  \item{\code{male}}{: gender; male = 1, female = 0.}
  \item{\code{dfmo}}{: treatment (DFMO) group = 1; placebo = 0.}
  \item{\code{priorTumor}}{: number of prior tumor from diagnosis to randomization.}
  \item{\code{countBC}}{: number of newly developed basal cell carcinomas tumors since
  last observation time.}
  \item{\code{countSC}}{: number of newly developed squamous cell carcinomas
  tumors since last observation time.}
  \item{\code{count}}{: number of newly developed non-melanoma tumors
  since last observation time; this is equal to \code{countBC + countSC}.}
}}
\usage{
data(skinTumor)
}
\description{
A data frame contains data on the recurrence of skin tumor.
The original data is available in Table A.3. of Sun and Zhao (2013).
This dataset contains records of 290 patients.
}
\examples{
data(skinTumor)
library(ggplot2)
ggplot(skinTumor, aes(time, id, width = 25, height = 2)) +
    geom_tile(aes(fill = count)) + theme_bw() +
    facet_grid(dfmo ~ ., scales = "free_y", as.table = FALSE,
               labeller = labeller(dfmo = function(x) paste("DFMO =", x))) +
    scale_fill_gradient(low = "grey", high = "black") +
    scale_x_continuous(breaks = seq(0, 2000, 200)) +
    labs(fill = "Count") + xlab("Time in days")
}
\references{
Chiou, S., Xu, G., Yan, J., and Huang, C.-Y. (2017).
Semiparametric estimation of the accelerated mean model with panel count data under
informative examination times. \emph{Biometrics}, to appear. <doi: 10.1111/biom.12840>.

Sun, J. and Zhao, X. (2013). Statistical Analysis of Panel Count
 Data. New York: Springer.
}
\seealso{
\code{skiTum}
}
