% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssMRCD_methods.R
\name{plot.ssMRCD}
\alias{plot.ssMRCD}
\title{Plot Method for ssMRCD Object}
\usage{
\method{plot}{ssMRCD}(
  x,
  type = c("convergence", "ellipses", "ellipses_geo"),
  variables = NULL,
  geo_centers = NULL,
  manual_rescale = 1,
  tolerance = 0.95,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"ssMRCD"}.}

\item{type}{Character string or vector specifying the type of plot(s) to produce. Available options are \code{"convergence"}, \code{"ellipses"}, and \code{"ellipses_geo"}. See Details.}

\item{variables}{A character vector of length 2 specifying the variable names (columns of the data) used to compute and plot the covariance ellipses.}

\item{geo_centers}{A matrix specifying the spatial/geographical coordinates of the group centers. Required when \code{type = "ellipses_geo"}.}

\item{manual_rescale}{Numeric scaling factor to adjust the size of ellipses in \code{"ellipses_geo"} plots.}

\item{tolerance}{Numeric value (between 0 and 1) specifying the quantile used to define tolerance ellipses. Default is \code{0.95}.}

\item{...}{Further arguments passed to plotting functions.}
}
\value{
A named list of ggplot2 plot objects:
\item{plot_convergence}{Plot showing convergence diagnostics (if \code{"convergence"} selected).}
\item{plot_ellipses}{Plot of covariance ellipses in variable space (if \code{"ellipses"} selected).}
\item{plot_geoellipses}{Plot of covariance ellipses in geographical space (if \code{"ellipses_geo"} selected).}
}
\description{
Produces diagnostic plots for an object of class \code{"ssMRCD"} including convergence behavior and visualizations of the covariance matrices.
}
\details{
\strong{type = "convergence"}:
Displays the convergence behavior of the objective function across C-step iterations for each initialization. Red lines indicate non-monotonic convergence.

\strong{type = "ellipses"}:
Shows Mahalanobis tolerance ellipses for each group based on their estimated covariance matrix. Only the two variables specified in \code{variables} are visualized. The global MCD ellipse may be shown for comparison (if included elsewhere).

\strong{type = "ellipses_geo"}:
Projects group-wise covariance ellipses onto a geographical coordinate system (e.g., spatial map), using the positions given in \code{geo_centers}. The ellipses are scaled using \code{manual_rescale} and drawn using the same two variables as for \code{type = "ellipses"}.
}
\examples{
set.seed(1)
data <- matrix(rnorm(2000), ncol = 4)
colnames(data) <- paste0("V", 1:4)
coords <- matrix(rnorm(1000), ncol = 2)
groups <- sample(1:10, 500, replace = TRUE)
lambda <- 0.3

outs <- locOuts(data = data,
                              coords = coords,
                              groups = groups,
                              lambda = lambda,
                              k = 10)

# Plot convergence
plot(x = outs$ssMRCD, type = "convergence")

# Plot ellipses in variable space
plot(x = outs$ssMRCD, type = "ellipses", variables = c("V1", "V2"))

# Plot ellipses in geographical space
centers <- matrix(rnorm(20), ncol = 2)  # example centers for 10 groups
plot(x = outs$ssMRCD, type = "ellipses_geo", geo_centers = centers, variables = c("V1", "V2"))

}
\seealso{
\code{\link[ssMRCD]{ssMRCD}},
  \code{\link[ssMRCD]{locOuts}},
  \code{\link[ssMRCD]{plot.locOuts}}
}
