% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahc_colouring.R
\name{ahc_colouring}
\alias{ahc_colouring}
\title{Agglomerative Hierarchical Clustering (AHC) Colouring for Event Trees}
\usage{
ahc_colouring(event_tree_obj, level_separation = 1000, node_distance = 300)
}
\arguments{
\item{event_tree_obj}{A list containing an event tree or staged tree, and other relevant data for the event tree processing.}

\item{level_separation}{Numeric value defining the level separation between nodes in the event tree (default is 1000).}

\item{node_distance}{Numeric value defining the distance between nodes (default is 300).}
}
\value{
A \code{visNetwork} object representing the staged tree.
}
\description{
This function applies Agglomerative Hierarchical Clustering (AHC) to colour the nodes of an event tree, taking into account their outgoing edges and stage information. It returns a coloured event tree based on the computed priors.
}
\details{
This function processes an event tree or partial staged tree, calculates priors based on the outgoing edges from each node, and performs Agglomerative Hierarchical Clustering (AHC) to colour the nodes of the event tree. It returns a \code{visNetwork} object that can be visualized as a coloured event tree. The function also computes the likelihood and scores based on merging stages in the event tree.
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
event_tree
coloured_tree <- ahc_colouring(event_tree)
coloured_tree

}
