% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_priors.R
\name{specify_priors}
\alias{specify_priors}
\title{Specify Priors for a Staged Tree Object}
\usage{
specify_priors(
  staged_tree_obj,
  prior_type = "Uniform",
  ask_edit = TRUE,
  print_colours = TRUE
)
}
\arguments{
\item{staged_tree_obj}{A staged tree object containing the nodes and edges data for the tree.}

\item{prior_type}{A character string indicating the prior type. Options are:
\itemize{
\item "Uniform": Assigns a Uniform (1,1) prior based on the outgoing edges.
\item "Phantom": Calculates a Phantom Individuals prior by initialising an alpha based on the maximum number of outgoing edges in the tree and dividing that evenly throughout the tree.
\item "Custom": Allows the user to manually specify the prior values for each node.
}}

\item{ask_edit}{If TRUE, this allows you to edit priors after choosing an uninformative prior type.}

\item{print_colours}{If TRUE, this prints a colour key for stages. Default is TRUE.}
}
\value{
A data frame containing the updated nodes data with the specified priors and their means.
}
\description{
This function assigns priors to the nodes of a staged tree object. The user can choose from different types of priors, including "Uniform", "Phantom", and "Custom".
}
\details{
The function checks if the necessary columns and structure are present in the input staged tree object. It performs validation on the nodes' levels and ensures that no nodes with non-minimum or non-maximum levels have the colour \verb{#FFFFFF}.
For the "Uniform" and "Phantom" priors, the function calculates the priors for each node based on their outgoing edges and propagates them through connected nodes. The user can edit these priors if desired.
The "Custom" option allows the user to manually input prior values for each row. If incorrect values are provided, an error will be raised.
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
coloured_tree <- ahc_colouring(event_tree)
tree_priors <- specify_priors(coloured_tree, prior_type = "Uniform", ask_edit = FALSE)
}
