% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deathFunction.R
\name{deathFuncDefault}
\alias{deathFuncDefault}
\alias{deathFunc}
\alias{deathFunction}
\title{Death Rate Function}
\usage{
deathFuncDefault(stage, x, time, species, strain)
}
\arguments{
\item{stage}{(integer). The numbered life stage for which to return a death rate.}

\item{x}{Vector of state variables within the DDE solver. To access a variable use:
x$speciesName['stageName',strainNumber]
e.g. for species 'Bacteria', stage 'reproductive', strain 2 use
x$Bacteria['reproductive',2]
If there is only one stage and strain in species 'Food', for example, use
x$Food[1,1]}

\item{time}{(scalar). The current time point in the DDE solver.}

\item{species}{(integer). The numbered species for which to return a death rate.}

\item{strain}{(integer). The numbered strain for which to return a death rate.}
}
\value{
per capita death rate (units of inverse time) for the strain, stage,species and time specified.
}
\description{
Return the per capita rate of death (per unit time)
}
