% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_2pop_norm.R
\name{ci_2pop_norm}
\alias{ci_2pop_norm}
\title{Confidence Interval for the normal distribution parameters - 2 populations}
\usage{
ci_2pop_norm(
  x,
  y,
  sd_pop_1 = NULL,
  sd_pop_2 = NULL,
  var_equal = FALSE,
  parameter = "mean",
  conf_level = 0.95,
  type = "two.sided",
  na.rm = F
)
}
\arguments{
\item{x}{a (non-empty) numeric vector.}

\item{y}{a (non-empty) numeric vector.}

\item{sd_pop_1}{a number specifying the known standard deviation of the first population. Default value is \code{NULL}.}

\item{sd_pop_2}{a number specifying the known standard deviation of the second population. Default value is \code{NULL}.}

\item{var_equal}{a logical variable indicating whether to treat the two variances as being equal. If \code{TRUE} then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{parameter}{a character string specifying the parameter in the normal distribution. Must be one of "mean" (confidence interval for mean difference) or "variance" (confidence interval for variance ratio). Default value is "mean".}

\item{conf_level}{confidence level of the returned confidence interval. Must be a single number between 0 and 1.}

\item{type}{a character string specifying the type of confidence interval. Must be one of "two.sided" (default), "right" or "left".}

\item{na.rm}{a logical value indicating whether \code{NA} values should be removed before the computation proceeds.}
}
\value{
A 1 x 3 tibble with 'lower_ci', 'upper_ci', and 'conf_level' columns. Values correspond to the lower and upper bounds of the confidence interval, and to the confidence level, respectively.
}
\description{
Computes the confidence interval for the difference in two population means or
computes the confidence interval for the ratio of two population variances
according to the \code{parameter} argument.
}
\details{
\code{type} specifies the type of confidence interval. If \code{type} is "two.sided",  the returned confidence interval is \code{(lower_ci, upper_ci)} when \code{parameter} is "mean" or "variance". If \code{type} is "left", the returned confidence interval is \code{(lower_ci, Inf)} when \code{parameter} is "mean" or "variance". And, finally, is \code{type} is "right", the returned confidence interval is \code{(-Inf, upper_ci))} when \code{parameter} is "mean", and the returned confidence interval is \code{(0, upper_ci)} when \code{parameter} is "variance".
}
\examples{
x <- rnorm(1000, mean = 0, sd = 2)
y <- rnorm(1000, mean = 0, sd = 1)
# confidence interval for difference in two means, unknown variances
ci_2pop_norm(x, y)

x <- rnorm(1000, mean = 0, sd = 2)
y <- rnorm(1000, mean = 0, sd = 3)
# confidence interval for difference in two means, known variances
ci_2pop_norm(x, y, sd_pop_1 = 2, sd_pop_2 = 3)

x <- rnorm(1000, mean = 0, sd = 2)
y <- rnorm(1000, mean = 0, sd = 3)
# confidence interval for the ratoi of two population variance
ci_2pop_norm(x, y, parameter = "variance")

}
