% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switch-functions.R
\name{extract_stats_type}
\alias{extract_stats_type}
\alias{stats_type_switch}
\title{Switch the type of statistics.}
\usage{
extract_stats_type(type)

stats_type_switch(type)
}
\arguments{
\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}
}
\description{
Relevant mostly for \code{{ggstatsplot}} and \code{{statsExpressions}} packages, where
different statistical approaches are supported via this argument: parametric,
non-parametric, robust, and Bayesian. This switch function converts strings
entered by users to a common pattern for convenience.
}
\examples{
extract_stats_type("p")
extract_stats_type("bf")
}
