% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one-sample-test.R
\name{one_sample_test}
\alias{one_sample_test}
\title{One-sample tests}
\usage{
one_sample_test(
  data,
  x,
  type = "parametric",
  test.value = 0,
  alternative = "two.sided",
  digits = 2L,
  conf.level = 0.95,
  tr = 0.2,
  bf.prior = 0.707,
  effsize.type = "g",
  ...
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{x}{A numeric variable from the data frame \code{data}.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{test.value}{A number indicating the true value of the mean (Default:
\code{0}).}

\item{alternative}{a character string specifying the alternative
    hypothesis, must be one of \code{"two.sided"} (default),
    \code{"greater"} or \code{"less"}.  You can specify just the initial
    letter.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{conf.level}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of \code{1/2}, \code{sqrt(2)/2}, and \code{1}, respectively. In case of an ANOVA, this
value corresponds to scale for fixed effects.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"d"} (for Cohen's \emph{d}) or \code{"g"} (for Hedge's \emph{g}).}

\item{...}{Currently ignored.}
}
\value{
The returned tibble data frame can contain some or all of the following columns (the exact columns will depend on the statistical test):
\itemize{
\item \code{statistic}: the numeric value of a statistic
\item \code{df}: the numeric value of a parameter being modeled (often degrees
of freedom for the test)
\item \code{df.error} and \code{df}: relevant only if the statistic in question has
two degrees of freedom (e.g. anova)
\item \code{p.value}: the two-sided \emph{p}-value associated with the observed statistic
\item \code{method}: the name of the inferential statistical test
\item \code{estimate}: estimated value of the effect size
\item \code{conf.low}: lower bound for the effect size estimate
\item \code{conf.high}: upper bound for the effect size estimate
\item \code{conf.level}: width of the confidence interval
\item \code{conf.method}: method used to compute confidence interval
\item \code{conf.distribution}: statistical distribution for the effect
\item \code{effectsize}: the name of the effect size
\item \code{n.obs}: number of observations
\item \code{expression}: pre-formatted expression containing statistical details
}

For examples, see \href{https://indrajeetpatil.github.io/statsExpressions/articles/web_only/dataframe_outputs.html}{data frame output vignette}.
}
\description{
Parametric, non-parametric, robust, and Bayesian one-sample tests.
}
\section{One-sample tests}{


The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}

\strong{Hypothesis testing}\tabular{lll}{
   Type \tab Test \tab Function used \cr
   Parametric \tab One-sample Student's \emph{t}-test \tab \code{stats::t.test()} \cr
   Non-parametric \tab One-sample Wilcoxon test \tab \code{stats::wilcox.test()} \cr
   Robust \tab Bootstrap-\emph{t} method for one-sample test \tab \code{WRS2::trimcibt()} \cr
   Bayesian \tab One-sample Student's \emph{t}-test \tab \code{BayesFactor::ttestBF()} \cr
}


\strong{Effect size estimation}\tabular{llll}{
   Type \tab Effect size \tab CI available? \tab Function used \cr
   Parametric \tab Cohen's \emph{d}, Hedge's \emph{g} \tab Yes \tab \code{effectsize::cohens_d()}, \code{effectsize::hedges_g()} \cr
   Non-parametric \tab \emph{r} (rank-biserial correlation) \tab Yes \tab \code{effectsize::rank_biserial()} \cr
   Robust \tab trimmed mean \tab Yes \tab \code{WRS2::trimcibt()} \cr
   Bayes Factor \tab difference \tab Yes \tab \code{bayestestR::describe_posterior()} \cr
}
}

\section{Citation}{
Patil, I., (2021). statsExpressions: R Package for Tidy Dataframes and Expressions with Statistical Details. Journal of Open Source Software, 6(61), 3236, https://doi.org/10.21105/joss.03236
}

\examples{
# for reproducibility
set.seed(123)

# ----------------------- parametric -----------------------

one_sample_test(mtcars, wt, test.value = 3)

# ----------------------- non-parametric -------------------

one_sample_test(mtcars, wt, test.value = 3, type = "nonparametric")

# ----------------------- robust ---------------------------

one_sample_test(mtcars, wt, test.value = 3, type = "robust")

# ----------------------- Bayesian -------------------------

one_sample_test(mtcars, wt, test.value = 3, type = "bayes")
}
