% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{.check_na}
\alias{.check_na}
\title{Check for NA values}
\usage{
.check_na(x, allow_na = TRUE, x_arg = caller_arg(x), call = caller_env())
}
\arguments{
\item{x}{The object to check.}

\item{allow_na}{\verb{(length-1 logical)} Are NA values ok?}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}
}
\value{
\code{NULL}, invisibly, if \code{x} passes the check.
}
\description{
Checks for \code{NA} values in \code{x}, throwing an error if any are found and
\code{allow_na} is \code{FALSE}.
}
\keyword{internal}
