% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_chr.R
\name{.has_regex_pattern}
\alias{.has_regex_pattern}
\title{Detect a regex pattern in a character vector}
\usage{
.has_regex_pattern(x, regex)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{regex}{\verb{(character, list, or stringr_pattern)} One or more optional
regular expressions to test against the values of \code{x}. This can be a
character vector, a list of character vectors, or a pattern object from the
\{stringr\} package (e.g., \code{stringr::fixed("a.b")}). The default error
message for non-matching values will include the pattern itself (see
\code{\link[=regex_must_match]{regex_must_match()}}). To provide a custom message, supply a named
character vector where the value is the regex pattern and the name is the
message that should be displayed. To check that a pattern is \emph{not} matched,
attach a \code{negate} attribute set to \code{TRUE}. If a complex regex pattern
throws an error, try installing the stringi package.}
}
\value{
A logical vector of matches in \code{x} to \code{regex}.
}
\description{
A wrapper around \code{\link[stringi:stri_detect]{stringi::stri_detect_regex()}} and \code{\link[base:grep]{base::grepl()}} that
prefers the \code{stringi} implementation if the package is available.
}
\keyword{internal}
