% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_unexported.R
\name{.to_cls_from_fct}
\alias{.to_cls_from_fct}
\title{Coerce an object from a factor to a specific class}
\usage{
.to_cls_from_fct(
  x,
  to_cls_fn,
  to_cls_args,
  to_class,
  coerce_factor = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{to_cls_fn}{\verb{(function)} The \verb{to_*()} function to use for coercion.}

\item{to_cls_args}{\code{(list)} A list of additional arguments to pass to
\code{to_cls_fn()}.}

\item{to_class}{\verb{(length-1 character)} The name of the class to coerce to.}

\item{coerce_factor}{\verb{(length-1 logical)} Should factors with values such as
"1" and "2.0" be considered numeric-ish? Note that this package uses the
character value from the factor, while \code{\link[=as.integer]{as.integer()}} and \code{\link[=as.double]{as.double()}} use
the integer index of the factor.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}
}
\value{
\code{x} coerced to the target class.
}
\description{
A helper that wraps around a \verb{to_*()} function to provide a standard way to
coerce factors.
}
\keyword{internal}
