% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empiricalobjective.R
\name{empiricalobjective}
\alias{empiricalobjective}
\title{Generate an empirical objective function for item selection.}
\usage{
empiricalobjective(
  criteria = c("rmsea", "srmr", "crel"),
  add = c("chisq", "df", "pvalue"),
  x = NULL,
  n = 50,
  side = NULL,
  skew = FALSE,
  scale = 1,
  matrices = NULL,
  fixed = NULL,
  comparisons = NULL,
  ...
)
}
\arguments{
\item{criteria}{A vector of names of criteria included in the objective function. Defaults to \code{c('rmsea', 'srmr', 'crel')}.}

\item{add}{A vector of names of criteria not used in the objective function, but added in order to be included in the log of solutions.}

\item{x}{Either a vector of values or an object of class \code{stuartOutput} from which to determine values in the objective function. If \code{NULL} (the default) values are generated from criteria-specific presets.}

\item{n}{Number of values to use in function determining. Defaults to 50, meaning if \code{side = 'top'} the 50 largest values are used to determine discrimination and difficulty parameters for each criterion.}

\item{side}{Which side good values are located at. \code{'top'} means large values are good (e.g. Reliability), \code{'bottom'} means small values are good (e.g. RMSEA), and \code{'middle'} means average values are good (e.g. factor correlations).}

\item{skew}{Whether to account for skew in the distribution using the \code{psn()} function from the \code{sn}-Package. Defaults to \code{FALSE}, meaning a normal distribution is used.}

\item{scale}{A numeric scale to use in weighting the objective component. Defaults to 1.}

\item{matrices}{An object of class \code{stuartObjectiveMatrices} to include matrices (e.g. latent correlations) into the objective function.}

\item{fixed}{An object of class \code{stuartFixedObjective} to include already previously defined fixed objectives.}

\item{comparisons}{A vector of names of criteria included in the objective function which are related to model comparisons (e.g. when determining measurement invariance).}

\item{...}{Additional arguments.}
}
\value{
Returns an object of class \code{stuartFixedObjective}
}
\description{
Generate an empirical objective function from default or empirical values for use in an item selection using STUART.
}
\seealso{
\code{\link{fixedobjective}}, \code{\link{extractobjective}}, \code{\link{objectivematrices}}
}
\author{
Martin Schultze
}
