% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_tbl.R
\name{cat_tbl}
\alias{cat_tbl}
\title{Summarize a categorical variable}
\usage{
cat_tbl(data, var, na.rm = FALSE, only = NULL, ignore = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{var}{A character string of the name of a variable in \code{data}
containing categorical data.}

\item{na.rm}{A logical value indicating whether missing values should be
removed before calculations. Default is \code{FALSE}.}

\item{only}{A character string or vector of character strings of the types
of summary data to return. Default is \code{NULL}, which returns both counts and
percentages. To return only counts or percentages, use \code{count} or \code{percent},
respectively.}

\item{ignore}{An optional vector that contains values to exclude from \code{var}.
Default is \code{NULL}, which retains all values.}
}
\value{
A tibble showing the count and percentage of each category in \code{var}
}
\description{
\code{cat_tbl()} summarizes nominal or categorical variables,
returning frequency counts and percentages.
}
\examples{
cat_tbl(data = nlsy, var = "gender")

cat_tbl(data = nlsy, var = "race", only = "count")

cat_tbl(data = nlsy,
        var = "race",
        ignore = "Hispanic",
        only = "percent",
        na.rm = TRUE)

}
\author{
Ama Nyame-Mensah
}
