% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui.R
\name{gui}
\alias{gui}
\alias{$.gui}
\alias{print.gui}
\alias{is.gui}
\title{A GUI object.}
\usage{
\method{$}{gui}(gui, x)

\method{print}{gui}(x, ...)

is.gui(x)
}
\arguments{
\item{gui}{A \code{gui} object..}

\item{x}{An object or a function for \code{$}.}

\item{...}{Further arguments (not used yet).}
}
\description{
The \code{gui} object contains and manages GUI-related data.
}
\examples{
# Create a GUI
gui_add("myGUI")
is.gui(myGUI)
myGUI
# Put an object in the GUI environment (fake button)
myGUI$button <- "my_button"
# Retrieve it
myGUI$button
# Get the curent status of the GUI
myGUI$status
# Eliminate this GUI and all its objects
gui_remove("myGUI")
}
\seealso{
\code{\link[=gui_add]{gui_add()}}
}
\concept{GUI API implementation}
\keyword{misc}
