% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{lang2calls}
\alias{lang2calls}
\title{Separate calls}
\usage{
lang2calls(x)
}
\arguments{
\item{x}{\code{language} object or a list of thereof}
}
\value{
Given a \code{call}, an \code{expression}, a list of \code{call}s or a list of \code{expression}s, returns a list of \code{calls}.
Symbols and atomic vectors (which may get mixed up in a list) are returned wrapped in list.
}
\description{
Converts language object or lists of language objects to list of simple calls.
}
\examples{
# use non-exported function from teal.code
lang2calls <- getFromNamespace("lang2calls", "teal.code")
expr <- expression(
  i <- iris,
  m <- mtcars
)
lang2calls(expr)
}
\keyword{internal}
