% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{norm_chisq}
\alias{norm_chisq}
\title{Normalized Chi-Squared Test for Circular Data}
\usage{
norm_chisq(obs, prd, unc)
}
\arguments{
\item{obs}{Numeric vector containing the observed azimuth of
\eqn{\sigma_{Hmax}}{SHmax},
same length as \code{prd}}

\item{prd}{Numeric vector containing the modeled azimuths of
\eqn{\sigma_{Hmax}}{SHmax}, i.e.
the return object from \code{model_shmax()}}

\item{unc}{Uncertainty of observed \eqn{\sigma_{Hmax}}{SHmax}, either a
numeric vector or a number}
}
\value{
Numeric vector
}
\description{
A quantitative comparison between the predicted and observed directions of
\eqn{\sigma_{Hmax}}{SHmax} is obtained by the calculation of the average
azimuth and by a normalized \eqn{\chi^2}{chi-squared} test.
}
\details{
The normalized \eqn{\chi^2}{chi-squared} test is
\deqn{ {Norm} \chi^2_i =
 = \frac{
   \sum^M_{i = 1} \left( \frac{\alpha_i - \alpha_{{predict}}}{\sigma_i}
   \right) ^2}
   {\sum^M_{i = 1} \left( \frac{90}{\sigma_i} \right) ^2 }}{
   (sum( ((obs-prd)/unc)^2 ) / sum( (90/unc)^2 )
   }
The value of the chi-squared test statistic is a number between 0 and 1
indicating the quality of the predicted \eqn{\sigma_{Hmax}}{SHmax}
directions. Low values
(\eqn{\le 0.15}) indicate good agreement,
high values (\eqn{> 0.7}) indicate a systematic misfit between predicted and
observed \eqn{\sigma_{Hmax}}{SHmax} directions.
}
\examples{
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na") # North America relative to
# Pacific plate
data(san_andreas)
point <- data.frame(lat = 45, lon = 20)
prd <- model_shmax(point, PoR)
norm_chisq(obs = c(50, 40, 42), prd = prd$sc, unc = c(10, NA, 5))

data(san_andreas)
prd2 <- PoR_shmax(san_andreas, PoR, type = "right")
norm_chisq(obs = prd2$azi.PoR, 135, unc = san_andreas$unc)
}
\references{
Wdowinski, S., 1998, A theory of intraplate
tectonics. \emph{Journal of Geophysical Research: Solid Earth}, \strong{103},
5037-5059, doi: 10.1029/97JB03390.
}
