% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_rrelu}
\alias{activation_rrelu}
\title{Rrelu}
\usage{
activation_rrelu(
  x,
  lower = 0.125,
  upper = 0.333333333333333,
  training = NULL,
  seed = NULL
)
}
\arguments{
\item{x}{A `Tensor`. Must be one of the following types: `float16`, `float32`, `float64`.}

\item{lower}{`float`, lower bound for random alpha.}

\item{upper}{`float`, upper bound for random alpha.}

\item{training}{`bool`, indicating whether the `call` is meant for training or inference.}

\item{seed}{`int`, this sets the operation-level seed. Returns:}
}
\value{
A `Tensor`. Has the same type as `x`.
}
\description{
rrelu function.
}
\details{
Computes rrelu function:
`x if x > 0 else random(lower, upper) * x` or
`x if x > 0 else x * (lower + upper) / 2`
depending on whether training is enabled.
See [Empirical Evaluation of Rectified Activations in Convolutional Network](https://arxiv.org/abs/1505.00853).
}
\section{Computes rrelu function}{

`x if x > 0 else random(lower, upper) * x` or `x if x > 0 else x * (lower + upper) / 2` depending on
whether training is enabled.
}

