% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_adjust_hsv_in_yiq}
\alias{img_adjust_hsv_in_yiq}
\title{Adjust hsv in yiq}
\usage{
img_adjust_hsv_in_yiq(
  image,
  delta_hue = 0,
  scale_saturation = 1,
  scale_value = 1,
  name = NULL
)
}
\arguments{
\item{image}{RGB image or images. Size of the last dimension must be 3.}

\item{delta_hue}{float, the hue rotation amount, in radians.}

\item{scale_saturation}{float, factor to multiply the saturation by.}

\item{scale_value}{float, factor to multiply the value by.}

\item{name}{A name for this operation (optional).}
}
\value{
Adjusted image(s), same shape and dtype as `image`.
}
\description{
Adjust hue, saturation, value of an RGB image in YIQ color space.
}
\details{
This is a convenience method that converts an RGB image to float
representation, converts it to YIQ, rotates the color around the
Y channel by delta_hue in radians, scales the chrominance channels
(I, Q) by scale_saturation, scales all channels (Y, I, Q) by scale_value,
converts back to RGB, and then back to the original data type. `image` is an RGB image.
The image hue is adjusted by converting the
image to YIQ, rotating around the luminance channel (Y) by
`delta_hue` in radians, multiplying the chrominance channels (I, Q) by
`scale_saturation`, and multiplying all channels (Y, I, Q) by
`scale_value`. The image is then converted back to RGB.
}
