% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_blend}
\alias{img_blend}
\title{Blend}
\usage{
img_blend(image1, image2, factor)
}
\arguments{
\item{image1}{An image Tensor of shape (num_rows, num_columns, num_channels) (HWC),
or (num_rows, num_columns) (HW), or (num_channels, num_rows, num_columns).}

\item{image2}{An image Tensor of shape (num_rows, num_columns, num_channels) (HWC),
or (num_rows, num_columns) (HW), or (num_channels, num_rows, num_columns).}

\item{factor}{A floating point value or Tensor of type tf.float32 above 0.0.}
}
\value{
A blended image Tensor of tf$float32.
}
\description{
Blend image1 and image2 using 'factor'.
}
\details{
Factor can be above 0.0. A value of 0.0 means only image1 is used.
A value of 1.0 means only image2 is used. A value between 0.0 and
1.0 means we linearly interpolate the pixel values between the two
images. A value greater than 1.0 "extrapolates" the difference
between the two pixel values, and we clip the results to values
between 0 and 255.
}
