% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops_.R
\name{img_flat_transforms_to_matrices}
\alias{img_flat_transforms_to_matrices}
\title{Flat transforms to matrices}
\usage{
img_flat_transforms_to_matrices(transforms, name = NULL)
}
\arguments{
\item{transforms}{Vector of length 8, or batches of transforms with shape `(N, 8)`.}

\item{name}{The name for the op.}
}
\value{
3D tensor of matrices with shape `(N, 3, 3)`. The output matrices
map the *output coordinates* (in homogeneous coordinates) of each transform
to the corresponding *input coordinates*.
}
\description{
Converts projective transforms to affine matrices.
}
\details{
Note that the output matrices map output coordinates to input coordinates.
For the forward transformation matrix, call `tf$linalg$inv` on the result.
}
\section{Raises}{

ValueError: If `transforms` have an invalid shape.
}

