% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hints.R
\name{ag_loop_vars}
\alias{ag_loop_vars}
\title{Specify loop variables}
\usage{
ag_loop_vars(
  ...,
  list = character(),
  include = character(),
  exclude = character(),
  undef = character()
)
}
\arguments{
\item{...}{Variables as bare symbol names}

\item{list, include, exclude}{optionally, the variable names as a character
vector (use this as an escape hatch from the \code{...} lazy evaluation
semantics).}

\item{undef}{character vector of symbols}
}
\value{
the specified hint invisibly.
}
\description{
This can be used to manually specify which variables are to be included
explicitly as \code{loop_vars} when autographing an expression into a
\code{tf.while_loop()} call, or the \code{loop_vars} equivalent when building a
\code{dataset.reduce()}.
}
\details{
Use of this is usually not required as the loop variables are automatically
inferred. Inference is done by statically looking through the loop body and
finding the symbols that are the targets of the common assignment operators
from base R (\verb{<-}, \verb{->}, \code{=}), from package:zeallot (\verb{\%<-\%} and \verb{\%->\%}) and
package:magrittr (\verb{\%<>\%}).

In certain circumstances, this approach may capture variables that are
intended to be local variables only. In those circumstances it is also
possible to specify them preceded with a \code{-}.

Note, the specified loop vars are expected to exist before the autographed
expression, and a warning is issued otherwise (usually immediately preceding
an error thrown when attempting to actually autograph the expression)

Only bare symbol names can be supplied as loop vars. In the future, support
may be expanded to allow for nested complex composites (e.g., specifying
variables that are nested within a more complex structure--passing
\code{ag_loop_vars(foo$bar$baz)} is currently not supported.)
}
\note{
The semantics of this function are inspired by base::rm()
}
\examples{
\dontrun{
i <- tf$constant(0L)

autograph({
  ag_loop_vars(x, i)
  while(x > 0) {
    if(x \%\%2 == 0)
      i <- i + 1L
    x <- x - 1
  }
})

## sometimes, a variable is infered to be a loop_var unnecessarily. For example
x <- tf$constant(1:10)

# imagine x is left over in the current scope from some previous calculations
# It's value is not important, but it exists
autograph({
  for(i in tf$constant(1:6)) {
    x <- i * i
    tf$print(x)
  }
})

# this will throw an error because `x` was infered to be a `loop_var`,
# but it's shape witin the loop body is different from what it was before.
# there are two solutions to prevent `x` from being captured as a loop_var
## 1) remove `x` from the current scope like so:
rm(x)

## 2) provide a hint like so:
ag_loop_vars(-x)

## if your variable names are being dynamically generated, there is an
## escape hatch for the lazy evaluation semantics of ...
ag_loop_vars(exclude = "x")
}
}
