
<!-- README.md is generated from README.Rmd. Please edit that file -->

# theorytools

<!-- badges: start -->

[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
[![R-CMD-check](https://github.com/cjvanlissa/theorytools/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/cjvanlissa/theorytools/actions/workflows/R-CMD-check.yaml)
[![Contributor
Covenant](https://img.shields.io/badge/Contributor%20Covenant-v2.0%20adopted-ff69b4.svg)](https://www.contributor-covenant.org/version/2/0/code_of_conduct.html)
<!-- badges: end -->

The `theorytools` package offers an integrated suite of tools for
creating, maintaining, and reusing FAIR (Findable, Accessible,
Interoperable, Reusable) theories in R. Designed to support transparent
and collaborative theory development, the package enables users to
formalize theories, track changes with version control, assess
pre-empirical coherence, and derive testable hypotheses. Aligning with
open science principles and workflows, theorytools facilitates the
systematic improvement of theoretical frameworks and enhances their
discoverability and usability.

## Installation

You can install the development version of theorytools from
[GitHub](https://github.com/) with:

``` r
# install.packages("pak")
pak::pak("cjvanlissa/theorytools")
```

## Documentation

[View the package website
here.](https://cjvanlissa.github.io/theorytools/)

Every user-facing function in the package is documented, and the
documentation can be accessed by running `?function_name` in the R
console, e.g., `?create_fair_theory`.

Moreover, you can check the package vignettes by running
`vignette(package = "theorytools")`, and read specific vignettes by
running, e.g., `vignette("fairtheory", package = "theorytools")`.

## Citing `theorytools`

You can cite the R-package with the following citation:

> Van Lissa, C. J. (2024). FAIR Theory Construction Toolkit (0.1.0) \[R
> package\]. <https://github.com/cjvanlissa/theorytools>

## Contributing and Contact Information

If you have ideas, please get involved. You can contribute by opening an
issue on GitHub, or sending a pull request with proposed features.
Contributions in code must adhere to the [tidyverse style
guide](https://style.tidyverse.org/).

- File a GitHub issue
  [here](https://github.com/cjvanlissa/theorytools/issues)
- Make a pull request
  [here](https://github.com/cjvanlissa/theorytools/pulls)

By participating in this project, you agree to abide by the [Contributor
Code of Conduct
v2.0](https://www.contributor-covenant.org/version/2/0/code_of_conduct.html).
