% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-data.R
\name{tsg_core_data}
\alias{tsg_core_data}
\title{Core Data}
\usage{
tsg_core_data(x, verbose = TRUE)
}
\arguments{
\item{x}{A list of tibble with grant data returned by \code{\link[=tsg_all_grants]{tsg_all_grants()}}.}

\item{verbose}{If \code{TRUE}, prints console messages on data retrieval progress.
Defaults to \code{TRUE}.}
}
\value{
A tibble with the core variables in the 360Giving standard.
}
\description{
Given a list returned by \code{\link[=tsg_all_grants]{tsg_all_grants()}} or \code{\link[=tsg_search_grants]{tsg_search_grants()}}, creates
a tibble with the core variables required by the
\href{https://standard.threesixtygiving.org/en/latest/}{360Giving} open standard,
as well as the publisher prefix and dataset identifier,
which are useful for data processing, and the licence the data was
published under.
}
\examples{
\dontrun{
grants <- tsg_all_grants()

df <- tsg_core_data(grants)
}
}
\seealso{
\code{\link[=tsg_process_data]{tsg_process_data()}}, which does the same processing but returns
all available variables.
}
