% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.tidylda.R
\name{posterior}
\alias{posterior}
\alias{posterior.tidylda}
\title{Draw from the marginal posteriors of a tidylda topic model}
\usage{
posterior(x, ...)

\method{posterior}{tidylda}(x, matrix, which, times, ...)
}
\arguments{
\item{x}{An object of class \code{tidylda}.}

\item{...}{Other arguments, currently not used.}

\item{matrix}{A character of either 'theta' or 'beta', indicating from which
matrix to draw posterior samples.}

\item{which}{Row index of \code{theta}, for document, or \code{beta}, for
topic, from which to draw samples. \code{which} may also be a vector of
indices to sample from multiple documents or topics simultaneously.}

\item{times}{Integer, number of samples to draw.}
}
\value{
\code{posterior} returns a tibble with one row per parameter per sample.

Returns a data frame where each row is a single sample from the posterior. 
Each column is the distribution over a single parameter. The variable \code{var}
is a facet for subsetting by document (for theta) or topic (for beta).
}
\description{
Sample from the marginal posteriors of a \code{tidylda} topic
  model. This is useful for quantifying uncertainty around the parameters of
  \code{beta} or \code{theta}.
}
\examples{
\donttest{
# load some data
data(nih_sample_dtm)

# fit a model
set.seed(12345)

m <- tidylda(
  data = nih_sample_dtm[1:20, ], k = 5,
  iterations = 200, burnin = 175
)

# sample from the marginal posterior corresponding to topic 1
t1 <- posterior(
  x = m,
  matrix = "beta",
  which = 1,
  times = 100  
)

# sample from the marginal posterior corresponding to documents 5 and 6
d5 <- posterior(
  x = m,
  matrix = "theta",
  which = c(5, 6),
  times = 100
)
}
}
\references{
Heinrich, G. (2005) Parameter estimation for text analysis. Technical report. 
\href{http://www.arbylon.net/publications/text-est.pdf}{http://www.arbylon.net/publications/text-est.pdf}
}
