% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_differences}
\alias{plot_differences}
\title{plot_difference}
\usage{
plot_differences(data, time_window = NULL)
}
\arguments{
\item{data}{nested data of type \code{tbl_df}.}

\item{time_window}{time window of the trend plot.}
}
\value{
\code{ggplot} object of the difference between the observed and synthetic
trends.

\code{ggplot} object of difference between the observed and synthetic control unit.
}
\description{
Plot the difference between the observed and synthetic control unit. The
difference captures the causal quantity (i.e. the magnitude of the difference
between the observed and counter-factual case).
}
\examples{


\donttest{

# Smoking example data
data(smoking)

smoking_out <-
smoking \%>\%

# initial the synthetic control object
synthetic_control(outcome = cigsale,
                  unit = state,
                  time = year,
                  i_unit = "California",
                  i_time = 1988,
                  generate_placebos=TRUE) \%>\%

# Generate the aggregate predictors used to generate the weights
  generate_predictor(time_window=1980:1988,
                     lnincome = mean(lnincome, na.rm = TRUE),
                     retprice = mean(retprice, na.rm = TRUE),
                     age15to24 = mean(age15to24, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1984:1988,
                     beer = mean(beer, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1975,
                     cigsale_1975 = cigsale) \%>\%

  generate_predictor(time_window=1980,
                     cigsale_1980 = cigsale) \%>\%

  generate_predictor(time_window=1988,
                     cigsale_1988 = cigsale) \%>\%


  # Generate the fitted weights for the synthetic control
  generate_weights(optimization_window =1970:1988,
                   Margin.ipop=.02,Sigf.ipop=7,Bound.ipop=6) \%>\%

  # Generate the synthetic control
  generate_control()

# Plot the observed and synthetic trend
smoking_out \%>\% plot_differences(time_window = 1970:2000)

}

}
