% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_trends}
\alias{plot_trends}
\title{plot_trends}
\usage{
plot_trends(data, time_window = NULL)
}
\arguments{
\item{data}{nested data of type \code{tbl_df}.}

\item{time_window}{time window of the trend plot.}
}
\value{
\code{ggplot} object of the observed and synthetic trends.
}
\description{
Plot the observed and synthetic trends for the treated units.
}
\details{
Synthetic control is a visual-based method, like Regression Discontinuity, so
inspection of the pre-intervention period fits is key assessing the sythetic
control's fit. A poor fit in the pre-period reduces confidence in the
post-period trend capturing the counterfactual.

See \code{?generate_control()} for information on how to generate a synthetic
control unit.
}
\examples{

\donttest{

# Smoking example data
data(smoking)

smoking_out <-
smoking \%>\%

# initial the synthetic control object
synthetic_control(outcome = cigsale,
                  unit = state,
                  time = year,
                  i_unit = "California",
                  i_time = 1988,
                  generate_placebos=TRUE) \%>\%

# Generate the aggregate predictors used to generate the weights
  generate_predictor(time_window=1980:1988,
                     lnincome = mean(lnincome, na.rm = TRUE),
                     retprice = mean(retprice, na.rm = TRUE),
                     age15to24 = mean(age15to24, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1984:1988,
                     beer = mean(beer, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1975,
                     cigsale_1975 = cigsale) \%>\%

  generate_predictor(time_window=1980,
                     cigsale_1980 = cigsale) \%>\%

  generate_predictor(time_window=1988,
                     cigsale_1988 = cigsale) \%>\%


  # Generate the fitted weights for the synthetic control
  generate_weights(optimization_window =1970:1988,
                   Margin.ipop=.02,Sigf.ipop=7,Bound.ipop=6) \%>\%

  # Generate the synthetic control
  generate_control()

# Plot the observed and synthetic trend
smoking_out \%>\% plot_trends(time_window = 1970:2000)

}


}
