% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_mosaic.group_tna}
\alias{plot_mosaic.group_tna}
\title{Plot State Frequencies as a Mosaic Between Two Groups}
\usage{
\method{plot_mosaic}{group_tna}(x, label, digits = 1L, ...)
}
\arguments{
\item{x}{A \code{group_tna} object.}

\item{label}{An optional \code{character} string that can be provided to specify
the grouping factor name if \code{x} was not constructed using a column name of
the original data.}

\item{digits}{An \code{integer} that determines the number of digits to use
for the chi-square test statistic and the p-value in the plot.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot State Frequencies as a Mosaic Between Two Groups
}
\examples{
model <- group_model(engagement_mmm)
plot_mosaic(model)

}
\seealso{
Basic functions
\code{\link{build_model}()},
\code{\link{hist.group_tna}()},
\code{\link{hist.tna}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.tna}()},
\code{\link{plot_frequencies}()},
\code{\link{plot_frequencies.group_tna}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.tna}()},
\code{\link{print.tna}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.tna}()},
\code{\link{tna-package}}
}
\concept{basic}
