% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bank-marketing.R
\name{bank_marketing_dataset}
\alias{bank_marketing_dataset}
\title{Bank marketing dataset}
\usage{
bank_marketing_dataset(
  root,
  split = "train",
  indexes = NULL,
  download = FALSE,
  with_call_duration = FALSE
)
}
\arguments{
\item{root}{path to the data location}

\item{split}{string. 'train' or 'submission'}

\item{indexes}{set of integers for subsampling (e.g. 1:41188)}

\item{download}{whether to download or not}

\item{with_call_duration}{whether the call duration should be included as a feature. Could lead to leakage. Default: FALSE.}
}
\value{
A torch dataset that can be consumed with \code{\link[torch:dataloader]{torch::dataloader()}}.
}
\description{
Prepares the Bank marketing dataset available on UCI Machine Learning repository \href{https://archive.ics.uci.edu/ml/datasets/Bank+Marketing}{here}
The data is available publicly for download, there is no need to authenticate.
Please cite the data as Moro et al., 2014
S. Moro, P. Cortez and P. Rita. A Data-Driven Approach to Predict the Success of Bank Telemarketing. Decision Support Systems, Elsevier, 62:22-31, June 2014
}
\examples{
if (torch::torch_is_installed() && FALSE) {
bank_mkt <- bank_marketing_dataset("./data", download = TRUE)
length(bank_mkt)
}
}
