% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tqk_get.R
\name{tqk_get}
\alias{tqk_get}
\title{Get quantitative data from korea}
\usage{
tqk_get(x, from = "1900-01-01", to = Sys.Date())
}
\arguments{
\item{x}{Stock x. only Korean type like "005930" is samsung.}

\item{from}{Optional for various time series functions. A character string representing a start date in YYYY-MM-DD format.}

\item{to}{Optional for various time series functions. A character string representing a end date in YYYY-MM-DD format.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Get quantitative data from korea
}
\examples{
\donttest{
  tqk_get(x = "005930")
  tqk_get(x = "005930", from = "2018-05-01")
  tqk_get(x = "005930", from = "2018-05-01", to = "2018-05-31")
}
}
