% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepfactor.R
\name{sepfactor}
\alias{sepfactor}
\title{Calculates separation factors between two transported species}
\usage{
sepfactor(main, secon, order = 2, mode = "batch", plot = TRUE)
}
\arguments{
\item{main}{Main species transport data. Must be a data frame generated
using \code{conc2frac}, data normalization is indifferent.}

\item{secon}{Undesired species transport data. Must be a data frame
generated using \code{conc2frac}, data normalization is
indifferent.}

\item{order}{Gives the polinomia order to be used if the secondary species
information needs to be corrected due to missing data.}

\item{mode}{Operation mode of the membranse system. Only \code{'batch'}
and \code{'continuous'} allowed. For semicontinuous systems
the separation factor is calculated as for continuous
systems.}

\item{plot}{Logical. If \code{TRUE}, the default, the plot is printed
in the current graphical device.}
}
\value{
Data frame with two variables: Time in the same units as provided
        data and SF with the separation factors at each time.
}
\description{
Given the transport data frames of two species, the function calculates
the separation factors of the main species A against a secondary species B
for each sample taken. If the dataset of secondary species is
smaller than that of the main species (e.g. if secondary species were
determined in only half the aliquots), the transport profile is completed
using \code{\link{fixSecondary}} function and a message will be printed.
}
\details{
Separation factor for batch systems at any time different from zero is
defined as \deqn{SF_{A/B}(t)=\frac{C_a/C_b}{C_a^0/C_b^0}} where \eqn{C_a}
and \eqn{C_b} are the concentrations of A and B, respectively, in the
strip solution at a time \eqn{t}, and \eqn{C_a^0} and \eqn{C_b^0} are
the concentrations of A and B, respectively, in the feed phase at
\eqn{t=0} (Chen et al., 2018).

For continuous or semicontinuous systems,
the separation factor is calculated according to the equation
\deqn{SF_{A/B}(t)\frac{C_{a,~s}/C_{b,~s}}{C_{a,~f}/C_{b,~f}}} where
\eqn{C_{a,~s}}, \eqn{C_{b,~s}} are A and B concentrations in the
strip phase at a time \eqn{t} and \eqn{C_{a,~f}}, \eqn{C_{b,~f}} are
the concentrations of A and B in the feed solution at a time \eqn{t}
(Koros and Shimidzu, 1996). Separation factor at \eqn{t=0} equals 1
indicating that no species separation has occurred yet.
}
\examples{
  data(seawaterLiNaK)
  sepfactor(main = seawaterLiNaK$Lithium.1,
            secon = seawaterLiNaK$Sodium.1)
  sepfactor(main = seawaterLiNaK$Lithium.1,
            secon = seawaterLiNaK$Potassium.1)
}
\references{
Q. B. Chen, Z. Y. Ji, J. Liu, Y. Y. Zhao, S. Z. Wang, J. S. Yuan,
Development of recovering lithium from brines by selective-electrodialysis:
Effect of coexisting cations on the migration of lithium, Journal of
Membrane Science 548 (2018) 408-420. doi:10.1016/j.memsci.2017.11.040.505

J. Koros, H. Ma, T. Shimidzu, Terminology for membranes and membrane
processes (iupac recommendations 1996), Pure and Applied Chemistry 68 (7)
(1996) 1479-1489. doi:10.1351/pac199668071479.
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
