% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_tree_to_obj.R
\name{write_tree_to_obj}
\alias{write_tree_to_obj}
\title{Write Tree to OBJ}
\usage{
write_tree_to_obj(tree_mesh, filename, materials = TRUE, fileext = ".obj")
}
\arguments{
\item{tree_mesh}{Tree mesh.}

\item{filename}{Filename for the OBJ file. If the file extension is not included, it
will automatically be added.}

\item{materials}{Default \code{TRUE}. Whether to also write the material (MTL) file.}

\item{fileext}{Default \code{".obj"}. File extension to be added if not present.}
}
\value{
None
}
\description{
Export the tree mesh to an OBJ file for use in other 3D programs
}
\examples{
#Save tree mesh to file
tempfileloc = tempfile()
write_tree_to_obj(tree_mesh(), filename = tempfileloc)
}
