% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_video_metadata.R
\name{update_video_metadata}
\alias{update_video_metadata}
\title{Update a YouTube Video's Metadata}
\usage{
update_video_metadata(
  video_id,
  title,
  category_id,
  description,
  privacy_status,
  made_for_kids
)
}
\arguments{
\item{video_id}{A character string specifying the ID of the video you want to update.}

\item{title}{A character string specifying the new title for the video.}

\item{category_id}{A character string specifying the new category ID for the video.}

\item{description}{A character string specifying the new description for the video.}

\item{privacy_status}{A character string specifying the new privacy status for the video ('public', 'private', or 'unlisted').}

\item{made_for_kids}{A boolean specifying whether the video is self-declared as made for kids.}
}
\value{
A list containing the server response after the update attempt.
}
\description{
This function updates the metadata of an existing YouTube video using the YouTube Data API.
}
\examples{
\dontrun{
update_video_metadata(video_id = "YourVideoID",
                      title = "New Video Title",
                      category_id = "24",
                      description = "New Description",
                      privacy_status = "public",
                      made_for_kids = FALSE)
}
}
