% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{crude.rates}
\alias{crude.rates}
\title{crude.rates}
\usage{
crude.rates(
  dat,
  outcome.names,
  cut.points = NULL,
  time.multiplier = 1,
  id.name = "id",
  t1.name = "t1",
  t2.name = "t2",
  grouping.variables = NULL,
  type = "overall",
  na.rm = TRUE,
  era.name = "period"
)
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{outcome.names}{A character vector of variable names from dat, expected to be binary,
representing the events of interest. The function calculates the rates of these events
within the specified time intervals. Variables not in dat or non-binary will be ignored.}

\item{cut.points}{A numeric vector specifying the end points of time intervals
for rate calculation. The data is split into eras based on these points, and rates
are computed for each interval.}

\item{time.multiplier}{A numeric value that scales the computed rates, useful for
converting rates to a standard time unit (e.g., per 1000 person-years).}

\item{id.name}{The character name of the identifying variable within dat, used for
tracking individuals across multiple data rows.}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the
end (right endpoint) of observation intervals.}

\item{grouping.variables}{A character vector of variables in dat to group the results by.}

\item{type}{Specifies the counting method: "distinct" for counting only new occurrences
separated by zeros, or "overall" (default) for counting all records with the event.}

\item{na.rm}{A logical indicating whether to exclude missing values from the calculations.}

\item{era.name}{The character string used to name the time period column in the resulting table.}
}
\value{
Returns a data table containing the calculated rates of the specified events for each
group and time period (era). The rates are presented alongside the grouping variables and the
specified era. Each row corresponds to a unique combination of the grouping variables and time
period, with the event rates adjusted according to the specified time.multiplier. The output
facilitates the comparison of event rates across different segments of follow-up time and
subgroups within the data.
}
\description{
Calculates the rate of specified events relative to the amount of
follow-up time, based on panel data. It allows for the segmentation of data into different
time periods (eras) and computes the event rates for these periods.
}
