% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{event.time}
\alias{event.time}
\title{event.time}
\usage{
event.time(
  dat,
  id.name,
  outcome.names,
  t1.name,
  time.function = "min",
  append.to.table = FALSE,
  event.name = "first.event"
)
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat, used for
tracking subjects across multiple rows.}

\item{outcome.names}{A character vector of variable names from dat that are expected to be binary,
representing the events of interest. The function calculates the time to these events
based on the specified function (e.g., first occurrence).}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}

\item{time.function}{The function to apply to the event times for each subject and outcome.
Options include "min" for the time of the first event, "max" for the last event, and
others like "mean" or "median" for average or median event times.}

\item{append.to.table}{A logical indicating whether to append the calculated event times
as new columns to the original data.frame (TRUE) or return them as a separate data frame (FALSE).}

\item{event.name}{The name to give the event time columns when they are appended to the data.}
}
\value{
If append.to.table is FALSE, returns a data table with the calculated event times for
each subject and specified outcome, keyed by the id.name. Each outcome will have its own column
named according to the original outcome name with the specified event.name appended (e.g.,
"outcome.first.event" for the first event times). If append.to.table is TRUE, the original data
table is returned with these new columns appended. This facilitates analyses focused on the timing
of events relative to the subjects' observation periods in the panel data.
}
\description{
Calculates the time to an event in a panel data structure, based on binary
outcome variables. It can determine the time of the first, last, or other statistical measures
(like mean or median) of event occurrences for each subject.
}
