% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twfy.R
\name{getMPs}
\alias{getMPs}
\title{Get information about Members of Parliament}
\usage{
getMPs(date = NULL, party = NULL, search = NULL)
}
\arguments{
\item{date}{Date for which the MP list is constructed}

\item{party}{Restrict to MPs in this party}

\item{search}{A search string}
}
\value{
a data.frame with columns \itemize{
 \item{\code{member_id} }{Member identifier}
 \item{\code{person_id} }{Person identifier}
 \item{\code{name} }{MP's first names then family name}
 \item{\code{party} }{Party}
 \item{\code{constituency} }{Constituency represented}
 \item{\code{office} }{NULL if no offices held, or a list with one
    element: a data.frame with column headings:
    \itemize{
      \item{\code{dept} }{The committee or commission name}
      \item{\code{position} }{Role, e.g. Member},
      \item{\code{from_date} }{Date tenure in office began}
      \item{\code{to_date} }{Date tenure in office ended, or
                            \code{9999-12-31} if still in office}
    }
  }
} or an empty list if parliament is dissolved.
}
\description{
Get information about Members of Parliament
}
