% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{coale_demeny_ltm}
\alias{coale_demeny_ltm}
\title{Coale-Demeny Model Life Tables}
\format{
An object of class \code{"list"}; consist of four \code{data.frame} for
\code{male}, \code{female} and \verb{both sexes}.
}
\usage{
data(coale_demeny_ltm)
}
\description{
The Coale-Demeny life tables consist of four sets of models, each representing
a distinct mortality pattern. Each model is arranged in terms of 25 mortality
levels, associated with different expectations of life at birth for females in
such a way that \code{e0} of 20 years corresponds to level 1 and \code{e0} of 80 years
corresponds to level 25.
}
\details{
The four underlying mortality patterns of the Coale-Demeny models are called
"North", "South", "East" and "West". They were identified through statistical
and graphical analysis of a large number of life tables of acceptable quality,
mainly for European countries.

Reference: United Nations (1990) "Step-by-step guide to the estimation of the child mortality"
\url{https://www.un.org/en/development/desa/population/publications/pdf/mortality/stepguide_childmort.pdf}
}
\references{
United Nations Population Studies (1990) Step-by-Step Guide
to the Estimation of Child Mortality No.107:1-83
(\href{https://www.un.org/en/development/desa/population/publications/pdf/mortality/stepguide_childmort.pdf}{United Nations})
}
\keyword{datasets}
