% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colext.R
\name{projected}
\alias{projected}
\alias{projected,ubmsFitColext-method}
\title{Projected Occupancy Trajectories}
\usage{
projected(object, ...)

\S4method{projected}{ubmsFitColext}(object, draws = NULL, re.form = NULL, ...)
}
\arguments{
\item{object}{A fitted dynamic occupancy model of class inheriting \code{ubmsFit}}

\item{...}{Currently ignored}

\item{draws}{Number of draws from the posterior to use in the check}

\item{re.form}{If \code{NULL}, any estimated group-level parameters ("random
effects") are included. If \code{NA}, they are ignored}
}
\value{
A matrix of occupancy values from the posterior predictive distribution.
  The dimensions are \code{draws} by number of sites x primary periods
  in site-major order.
}
\description{
Generate posterior draws of occupancy probability for all sites and primary
periods, i.e. the projected trajectory (Weir et al. 2009).
}
\references{
Weir LA, Fiske IJ, Royle J. 2009. Trends in Anuran
  Occupancy from Northeastern States of the North American Amphibian
  Monitoring Program. Herpetological Conservation and Biology.
  4: 389-402.
}
\seealso{
\code{\link{stan_colext}}
}
